<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>Washroom Hygiene Monitoring</title>

    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=instrument-sans:400,500,600" rel="stylesheet" />

    @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body class="bg-[#FDFDFC] dark:bg-[#0a0a0a] text-[#1b1b18] flex min-h-screen flex-col">

<header class="w-full max-w-6xl mx-auto p-6 flex justify-between items-center text-sm">
    <div class="font-semibold tracking-wide">
        🚻 Washroom Hygiene System
    </div>

    @if (Route::has('login'))
        <nav class="flex items-center gap-4">
            @auth
                <a href="{{ url('/dashboard') }}"
                   class="px-5 py-1.5 border rounded-sm hover:border-[#1915014a]
                          border-[#19140035] dark:border-[#3E3E3A]">
                    Dashboard
                </a>
            @else
                <a href="{{ route('login') }}"
                   class="px-5 py-1.5 rounded-sm hover:border-[#19140035]
                          border border-transparent">
                    Log in
                </a>

                @if (Route::has('register'))
                    <a href="{{ route('register') }}"
                       class="px-5 py-1.5 border rounded-sm
                              border-[#19140035] hover:border-[#1915014a]">
                        Register
                    </a>
                @endif
            @endauth
        </nav>
    @endif
</header>

<main class="flex items-center justify-center w-full px-6 py-12">
    <div class="flex flex-col lg:flex-row
                max-w-5xl w-full
                bg-white dark:bg-[#161615]
                shadow-[0_0_0_1px_rgba(26,26,0,0.16)]
                dark:shadow-[0_0_0_1px_#fffaed2d]
                rounded-lg overflow-hidden">

        <!-- LEFT CONTENT -->
        <div class="flex-1 p-8 lg:p-14 text-sm">
            <h1 class="text-lg font-medium mb-2">
                Smart Washroom Hygiene Monitoring
            </h1>

            <p class="text-[#706f6c] dark:text-[#A1A09A] mb-6 leading-relaxed">
                A real-time IoT platform to monitor hygiene devices, track usage,
                receive alerts, and ensure compliance across facilities.
            </p>

            <ul class="space-y-3 mb-8">
                <li>• Live device heartbeat & health status</li>
                <li>• RO & Dealer wise device management</li>
                <li>• Automatic alerts & audit logs</li>
                <li>• Role based access control</li>
            </ul>

            <div class="flex gap-3">
                <a href="{{ route('login') }}"
                   class="px-5 py-1.5 bg-[#f53003] text-white rounded-sm
                          hover:bg-[#e12a00]">
                    Enter Dashboard
                </a>

                <a href="{{ route('register') }}"
                   class="px-5 py-1.5 border rounded-sm
                          border-[#19140035] hover:border-[#1915014a]">
                    Create Account
                </a>
            </div>
        </div>

        <!-- RIGHT STATUS PANEL -->
        <div class="w-full lg:w-[360px]
                    bg-[#fff2f2] dark:bg-[#1D0002]
                    p-8 flex items-center">

            <div class="grid grid-cols-2 gap-4 w-full text-sm">
                <div class="bg-white dark:bg-[#161615] p-4 rounded shadow-sm">
                    <p class="text-[#f53003] font-medium">Devices</p>
                    <p class="text-xl font-semibold">Online</p>
                </div>

                <div class="bg-white dark:bg-[#161615] p-4 rounded shadow-sm">
                    <p class="text-green-600 font-medium">Hygiene</p>
                    <p class="text-xl font-semibold">OK</p>
                </div>

                <div class="bg-white dark:bg-[#161615] p-4 rounded shadow-sm">
                    <p class="text-orange-600 font-medium">Alerts</p>
                    <p class="text-xl font-semibold">Live</p>
                </div>

                <div class="bg-white dark:bg-[#161615] p-4 rounded shadow-sm">
                    <p class="text-purple-600 font-medium">Reports</p>
                    <p class="text-xl font-semibold">Daily</p>
                </div>
            </div>
        </div>

    </div>
</main>


</body>
</html>
