@extends('layouts.app')

@section('content')
<a href="{{route('device-data',$device->id)}}" class="btn btn-sm btn-secondary mb-3">← Back</a>

<div class="d-flex justify-content-between align-items-center mb-2">
    <h4>Device Logs – {{ $device->device_uid }}</h4>

      <span class="badge bg-dark text-white px-3 py-2 fw-semibold">
    🔄 Auto refresh in <span id="countdown">20</span>s
</span>
</div>

<form method="GET" class="row g-2 mb-3 align-items-end">
    <div class="col-md-3">
        <label class="form-label">From Date</label>
        <input type="date" name="from_date" value="{{ request('from_date') }}" class="form-control">
    </div>

    <div class="col-md-3">
        <label class="form-label">To Date</label>
        <input type="date" name="to_date" value="{{ request('to_date') }}" class="form-control">
    </div>

    <div class="col-md-6 d-flex gap-2">
        <button type="submit" class="btn btn-primary btn-sm">
            🔍 Filter
        </button>

        <a href="{{ route('device-logs-pdf', request()->all() + ['device' => $device->id]) }}"
           class="btn btn-danger btn-sm">
            📄 PDF
        </a>

        <a href="{{ route('device-logs-excel', request()->all() + ['device' => $device->id]) }}"
           class="btn btn-success btn-sm">
            📊 Excel
        </a>

        <a href="{{ route('device-log', $device->id) }}"
           class="btn btn-secondary btn-sm">
            ❌ Reset
        </a>
    </div>
</form>



<table class="table table-bordered bg-white">
    <thead class="table-light">
        <tr>
            <th>Ammonia</th>
            <th>Sulphur</th>
            <th>VOC</th>
            <th>Timestamp</th>
            <th>Received At</th>
        </tr>
    </thead>
    <tbody>
        @forelse($logs as $log)
            <tr>
                <td>{{ $log->ammonia ?? '-' }}</td>
                <td>{{ $log->sulphur ?? '-' }}</td>
                <td>{{ $log->voc ?? '-' }}</td>
                <td>{{ $log?->timestamp ? date('d-m-Y h:i:s A', strtotime($log->timestamp)) : '-' }}</td>
                <td>{{ $log?->updated_at ? date('d-m-Y h:i:s A', strtotime($log->updated_at)) : '-' }}</td>
            </tr>
        @empty
            <tr>
                <td colspan="5" class="text-center text-muted">No logs found</td>
            </tr>
        @endforelse
    </tbody>
</table>

<div class="d-flex justify-content-center mt-3">
    {{ $logs->links('pagination::bootstrap-5') }}
</div>

{{-- Auto Refresh Script --}}
<script>
    let seconds = 20;
    const countdownEl = document.getElementById('countdown');

    const timer = setInterval(() => {
        seconds--;
        countdownEl.textContent = seconds;

        if (seconds <= 0) {
            clearInterval(timer);
            window.location.reload();
        }
    }, 1000);
</script>
@endsection
