<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('device_data_logs', function (Blueprint $table) {
    $table->id();

    $table->foreignId('device_id')
        ->constrained('devices')
        ->cascadeOnDelete();

    $table->json('payload');
    $table->timestamp('received_at');

    $table->timestamps();

    $table->index('device_id');
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('device_data_logs');
    }
};
