<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('devices', function (Blueprint $table) {
    $table->id();
    $table->string('device_uid')->unique(); // ESP32 unique ID
    $table->string('name')->nullable();

    $table->unsignedBigInteger('ro_id')->nullable();
    $table->unsignedBigInteger('dealer_id')->nullable();

    $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('devices');
    }
};
