<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('incidents', function (Blueprint $table) {
    $table->id();
    $table->foreignId('ro_id')->constrained('ro_master');
    $table->timestamp('start_time');
    $table->timestamp('end_time')->nullable();
    $table->enum('sla_status', ['open','breached','closed'])->default('open');
    $table->timestamps();
});

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('incidents');
    }
};
