<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('device_master', function (Blueprint $table) {
            $table->id();
            $table->string('device_id')->unique();
            $table->foreignId('ro_id')->constrained('ro_master');
            $table->date('install_date');
            $table->timestamp('last_seen')->nullable();
            $table->enum('status', ['online', 'offline'])->default('offline');
            $table->timestamps();
        });

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('device_master');
    }
};
