<?php
namespace App\Http\Controllers;

use App\Models\Device;
use Maatwebsite\Excel\Facades\Excel;
use Barryvdh\DomPDF\Facade\Pdf;
use Illuminate\Http\Request;
use App\Exports\DeviceLogsExport;

class DeviceController extends Controller
{
    public function index()
    {
        // $devices = Device::with('latestData')
        //     ->when(auth()->user()->role === 'dealer', function ($q) {
        //         $q->where('ro_id', auth()->user()->ro_id);
        //     })
        //     ->get();

        $devices = Device::with([
            'latestData',
            'ro:id,name',
            'dealer:id,name'
        ])
        ->when(auth()->user()->role === 'dealer', function ($q) {
            $q->where('dealer_id', auth()->id());
        })
        ->when(auth()->user()->role === 'bpcl', function ($q) {
            $q->where('ro_id', auth()->user()->ro_id);
        })
        ->orderBy('id', 'desc')
        ->paginate(10); // 👈 PAGE SIZE


        return view('devices.index', compact('devices'));
    }

    public function show(Device $device)
    {
        $device->load('latestData');

        return view('devices.show', compact('device'));
    }

    public function logs1(Device $device)
    {
        $logs = $device->dataLogs()
            ->orderByDesc('received_at')
            ->paginate(10);

        return view('devices.logs', compact('device', 'logs'));
    }
    
    public function logs(Request $request, Device $device)
    {
        $query = $device->dataLogs()->orderByDesc('received_at');

        if ($request->from_date) {
            $query->whereDate('received_at', '>=', $request->from_date);
        }

        if ($request->to_date) {
            $query->whereDate('received_at', '<=', $request->to_date);
        }

        $logs = $query->paginate(10)->withQueryString();

        return view('devices.logs', compact('device', 'logs'));
    }


    public function exportExcel(Request $request, Device $device)
    {
        return Excel::download(
            new DeviceLogsExport($device, $request),
            'device_logs_'.$device->device_uid.'.xlsx'
        );
    }


    public function exportPdf(Request $request, Device $device)
    {
        $query = $device->dataLogs()->orderByDesc('received_at');

        if ($request->from_date) {
            $query->whereDate('received_at', '>=', $request->from_date);
        }

        if ($request->to_date) {
            $query->whereDate('received_at', '<=', $request->to_date);
        }

        $logs = $query->get();

        $pdf = Pdf::loadView('devices.logs-pdf', compact('device', 'logs'))
                  ->setPaper('a4', 'landscape');

        return $pdf->download('device_logs_'.$device->device_uid.'.pdf');
    }

}
