<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class DeviceLogsExport implements FromCollection, WithHeadings
{
    protected $device;
    protected $request;

    public function __construct($device, $request)
    {
        $this->device = $device;
        $this->request = $request;
    }

    public function collection()
    {
        $query = $this->device->dataLogs();

        if ($this->request->from_date) {
            $query->whereDate('received_at', '>=', $this->request->from_date);
        }

        if ($this->request->to_date) {
            $query->whereDate('received_at', '<=', $this->request->to_date);
        }

        return $query->orderByDesc('received_at')->get([
            'ammonia',
            'sulphur',
            'voc',
            'timestamp',
            'received_at',
        ]);
    }

    public function headings(): array
    {
        return ['Ammonia', 'Sulphur', 'VOC', 'Timestamp', 'Received At'];
    }
}
